#!/bin/sh

CMD=$1
UNAME=$2
PASSWD=$3
GROUP=$4

SMB_CONF="/etc/smb.conf"
log_shell="/usr/WebUI/nbin/log.sh"

PATH="$PATH:/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin:/usr/local/samba/bin"
export PATH

nas_passwd() {
	( echo "$PASSWD"
		sleep 3
		echo "$PASSWD" ) | passwd $UNAME
	if [ "$?" != "0" ]; then
		return $?
	fi
	# Allow time for the passwd database change to take effect
	sleep 1
	return 0
}

add_user() {
	if [ $UNAME = "www-data" ]; then
		pdbedit -a -u $UNAME -c "[N ]" -s $SMB_CONF -t <<EOF
$PASSWD
$PASSWD
EOF
    	return 0
	fi
	#adduser -D -H "$UNAME" -G "$GROUP" # -H: don't create home directory
	adduser -D -h /shares/internal/home/"$UNAME" "$UNAME" -G "$GROUP" -s nologin # -H: don't create home directory
	if [ "$?" != "0" ]; then
		return 11
	fi
	nas_passwd
	if [ "$?" != "0" ]; then
		return 21
	fi
	pdbedit -a "$UNAME" -s $SMB_CONF -t <<EOF
$PASSWD
$PASSWD
EOF
	if [ "$?" != "0" ]; then
		return 31
	fi
	/usr/WebUI/nbin/chFtpUserConfig.sh add "$UNAME"
	if [ "$?" != "0" ]; then
		return 41
	fi
	
	return 0
}

delete_user() {
	pdbedit -x $UNAME -s $SMB_CONF
	if [ "$?" != "0" ]; then
		return 32
	fi
	#deluser $UNAME
	sed -i /^$UNAME:/d /etc/passwd
	if [ "$?" != "0" ]; then
		return 12
	fi
	sed -i /^$UNAME:/d /etc/shadow
	if [ "$?" != "0" ]; then
		return 12
	fi
	rm -rf /shares/internal/home/$UNAME
	if [ "$?" != "0" ]; then
		return 12
	fi
	
	/usr/WebUI/nbin/chFtpUserConfig.sh del "$UNAME"
	if [ "$?" != "0" ]; then
		return 42
	fi
	rm -rf /shares/internal/home/$UNAME
	if [ "$?" != "0" ]; then
		return 52
	fi
	#echo /shares/internal/home/$UNAME
	return 0
}

modify_user() {
	nas_passwd
	if [ "$?" != "0" ]; then
		return 22
	fi

	smbpasswd -c $SMB_CONF -L -s $UNAME << EOF
$PASSWD
$PASSWD
EOF
	if [ "$?" != "0" ]; then
		return 33
	fi
	return 0
}

case "$CMD" in
  add)
	add_user
	return_value=$?
	if [ "$return_value" != "0" ]; then
		$log_shell user 127.0.0.1 \"add user $UNAME fail\"
	else
		$log_shell user 127.0.0.1 \"add user $UNAME success\"
	fi
	exit $return_value
	;;
  delete)
	delete_user
	return_value=$?
	if [ "$return_value" != "0" ]; then
		$log_shell user 127.0.0.1 \"delete user $UNAME fail\"
	else
		$log_shell user 127.0.0.1 \"delete user $UNAME success\"
	fi
	exit $return_value
	;;
  modify)
	modify_user
	return_value=$?
	if [ "$return_value" != "0" ]; then
		$log_shell user 127.0.0.1 \"change user $UNAME fail\"
	else
		$log_shell user 127.0.0.1 \"change user $UNAME success\"
	fi
	exit $return_value
	;;
  *)
	#echo $"Usage: $0 {add|delete|modify}" >> /tmp/abc
	exit 0
esac

exit $?
